<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Auth;
use App\Models\Customer;
use App\Models\CustomerSetting;
use App\Models\Setting;

class checkuser extends Controller
{
    //
    public function index()
    {
        if (Auth::guard('customer')->user()) {
            $customer = Customer::findOrFail(Auth::guard('customer')->user()->id);
            $data['customer'] = $customer;

            $permission = Setting::get();
            $data['permission'] = $permission;
            $data['customer_inactive_auto_logout_time'] = setting('customer_inactive_auto_logout_time');
            $data['customer_inactive_auto_logout'] = setting('customer_inactive_auto_logout');

            $redirectionstatus = null;
            if (setting('Customer_email_two_fact') == 'on' && CustomerSetting::where(['custs_id' => Auth::guard('customer')->user()->id, 'twofactorauth' => 'emailtwofact'])->exists()) {
                
                if (!(session()->get('twofactoremail') == Auth::guard('customer')->user()->email)) {
                    $redirectionstatus = 'twofactoremail';
                }
            } elseif (setting('Customer_google_two_fact') == 'on' && CustomerSetting::where(['custs_id' => Auth::guard('customer')->user()->id, 'twofactorauth' => 'googletwofact'])->exists()) {
                if (!(session()->get('googleauthid') == Auth::guard('customer')->user()->email)) {
                    $redirectionstatus = 'googletwofact';
                }
            }
            $data["email"] = $customer->email;
            $data['redirectionstatus'] = $redirectionstatus;
            return $data;
        }
    }
}
