<?php

namespace App\Http\Middleware;

use App\Models\Languages;
use Closure;
use Illuminate\Http\Request;
use App\Events\Bootload as InstallBootload;
use Illuminate\Support\Facades\Event;

class Checkinstallation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $installedpath = storage_path('installed');
        if (!file_exists($installedpath)) {
            $request->session()->flush();
            return redirect()->route('SprukoAppInstaller::welcome');
        }
        $language = Languages::with('translates')->get();
        foreach ($language as $item) {
            $directory = base_path('public/client/assets/i18n');
            if (!is_dir($directory)) {
                mkdir($directory, 0777, true);
            }
            $filename = $item->languagecode . '.json';
            $content = [];
            $content['is_rtl'] = $item->is_rtl;
            $content['translation'] = [];
            foreach ($item->translates as $it) {
                $content['translation'][$it->key] = $it->value;
            }
            $json = json_encode($content, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            $file_path = base_path('public/client/assets/i18n/' . $filename);
            file_put_contents($file_path, $json);
        }
        if((setting('newupdate') != config('installer.requirements.version')) && (setting('newupdate') != 'updated3.0')){
            if($request->path() != 'newupdate'){
                return redirect()->route('admin.newupdate');
            }
            return $next($request);
        }else{
            return $next($request);
        }
    }
}
