<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class DataRecovery
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (setting('update_setting') == null) {
            if ($request->is('detail/admin/*') && !$request->is('detail/admin/licenseinfoenter')) {
                return response()->json(['message' => 'licenseinfo'], 302);
            } else {
                return $next($request);
            }
        }else{
            if(setting('update_setting') == null){
                if($request->is('admin/*')){
                    return redirect()->route('admin.testinginfo');
                }else{
                    return $next($request);
                }
            }
        }
        return $next($request);
    }
}
