<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

use App\Models\EmailTemplate;

class mailmailablesend extends Mailable
{
    use Queueable, SerializesModels;


    public $template, $data;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($template, $data)
    {
        $this->template = $template;
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = EmailTemplate::where('code', $this->template)->first();

        $data = $this->data;
        
        $body = $template->body;
        $subject = $template->subject;

        $subject = $this->replacePlaceholders($template->subject, $this->data);
        $body = $this->replacePlaceholders($template->body, $this->data);

        return $this->subject($subject)->view('admin.email.template', ['emailBody' => $body]);
    }

    protected function replacePlaceholders($text, $data)
    {
        foreach ($data as $key => $value) {
            $text = str_replace(["{{{$key}}}", "{{ {$key} }}"], $value, $text);
        }
        return $text;
    }
}
