<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AllTransactions extends Model
{
    use HasFactory;

    protected $table = 'all_transactions';

    protected $fillable = [
        'category_id',
        'cust_id',
        'invoiceId',
        'amount',
        'currency',
        'transaction_id',
        'refundTransaction_id',
        'discount',
        'customerAmount',
        'payment_method',
        'dateIssued',
        'ticket_type',
        'ticket_id',
        'package_name',
        'package_id',
        'status',
        'city',
        'state',
        'country',
        'postal_code',
        'last4Digits',
        'cardType',
        'cardBrand',
        'cust_viewed',
        'payment_date',
    ];

    public function customInvoiceElements()
    {
        return $this->hasMany(CustomInvoiceFields::class,'parentId');
    }
    public function allInvoices()
    {
        return $this->hasOne(AllInvoices::class,'parentId');
    }
    
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'cust_id');   
    }

    public function refundComments()
    {   
        return $this->hasMany(RefundComment::class, 'refund_id')->with('cust', 'user.roles')->latest('created_at');
    }


    protected static function booted()
    {
        // Use retrieved event to automatically set the "image" attribute when loading an existing model

        static::updating(function ($model) {
            if ($model['enc_invoiceId']) {
                unset($model['enc_invoiceId']);
            }
            if ($model['enc_invId']) {
                unset($model['enc_invId']);
            }
            return;
        });
        static::updated(function ($model) {
            $model->modifyPurchaseCode();
        });
        static::retrieved(function ($model) {
            $model->modifyPurchaseCode();
        });
    }

    // Define a method to set the "image" attribute
    protected function modifyPurchaseCode()
    {
        if($this->invoiceId){
            $this['enc_invoiceId'] = encrypt($this->invoiceId);
        }
        if($this->id){
            $this['enc_invId'] = encrypt($this->id);
        }
    }
}
