<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeActivity extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'activity_type',
        'ip_address',
        'browser',
        'device',
        'ticket_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
