<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketCustomfield extends Model
{
    use HasFactory;

    protected $table = 'ticket_customfields';
    protected $fillable = [

        'cust_id',
        'fieldnames',
        'fieldtypes',
        'fieldtypes',
        'values',
        'privacymode',
        'ticket_id',

    ];



    protected static function booted()
    {
        // Use retrieved event to automatically set the "image" attribute when loading an existing model

        static::updating(function ($model) {
            if ($model) {
                unset($model['value']);
            }
            return;
        });
        static::retrieved(function ($model) {
            $model->modifyPurchaseCode();
        });
    }

    // Define a method to set the "image" attribute
    protected function modifyPurchaseCode()
    {
        if ($this->privacymode == 1) {
          
            $val = decrypt($this->values);
            $this['value'] = $val;
        } else {
            $this['value'] = $this->values;
        }
    }
}
