<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use App\Models\AllTransactions;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class PaidTicketNotifications extends Notification
{
    use Queueable;
    public $transaction;

    /**
     * Create a new notification instance.
     */
    public function __construct(AllTransactions $transaction)
    {
        $this->transaction = $transaction;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // return ['mail'];
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'itemStatus' => $this->transaction->status,
            'link' =>url ('/customer/custom-invoice/'.encrypt($this->transaction->id)),
            'status' => 'invoice',
            'tx_id' => encrypt($this->transaction->id),
            'invoice_id' => encrypt($this->transaction->invoiceId),
            'reason' => $this->transaction->refundReason,
        ];
    }
}
