<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Seeder;
use DB;

use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class UpdateVersion3_0 extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('settings')->insert([
            [
                'key' => 'isToken',
                'value' => false,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'email_delete',
                'value' => false,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'email_ticket_limit',
                'value' => 10,
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

        DB::table('email_templates')->insert([
            [
                'code' => 'when_send_customnotify_email_to_delete_guest_account',
                'title' => 'Send an email alert to the guest when they are not using the application.',
                'subject' => 'Your account is unused and will soon be deleted.',
                'variables_used' => 'customer_username,customer_email,customer_time,customer_months,customer_register_url',
                'body' => '<p>Attention {{customer_username}}</p><p>Your {{customer_email}} personal account has been unused for {{customer_months}}.</p><p>It would be helpful if you registered to the application.<br></p><p>Click here to <a href="{{customer_register_url}}" target="_blank">register</a></p><p>Note:  If you fail to register, your associated data will be deleted in {{customer_time}}.</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
